/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.network.packet;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.BlockEntityHelper;

public class UpdateLecternPagePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final String page;

    public UpdateLecternPagePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.page = buffer.m_130136_(100);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.page);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null && this.page != null) {
            Level world = player.m_20193_();
            BlockEntityHelper.get(LecternBlockEntity.class, (BlockGetter)world, this.pos).ifPresent(te -> {
                ItemStack stack = te.m_59566_();
                if (!stack.m_41619_()) {
                    BookHelper.writeSavedPageToBook(stack, this.page);
                }
            });
        }
    }

    public UpdateLecternPagePacket(BlockPos pos, String page) {
        this.pos = pos;
        this.page = page;
    }
}

